﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;


/// <summary>
/// Program Improvement reports methods and properties
/// </summary>
public class CReportsPI
{
    /// <summary>
    /// Default constructor
    /// </summary>
	public CReportsPI()
	{
		//
		// TODO: Add constructor logic here
		//
	}

    /// <summary>
    /// Get modules dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetPopModuleDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", BaseMstr.Key);
        
        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get scores dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetPopScoreDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", BaseMstr.Key);
    

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopScoreRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get series dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lSiteID"></param>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetPopModuleSeriesDS(BaseMaster BaseMstr,
                                        long lSiteID,
                                        long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nSiteID", lSiteID);
        plist.AddInputParameter("pi_nMID", lMID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopModuleSeriesRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


    /// <summary>
    /// get average score dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetPopScoreAvgDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopScoreAvgRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// get site id dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetPopSiteIDDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopSiteIDRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// get module dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetPopMIDDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopMIDRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// get average all dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lExcludeSite"></param>
    /// <returns></returns>
    public DataSet GetPopScoreAvgAllDS(BaseMaster BaseMstr,
                                        long lExcludeSite)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nExcludeSiteID", lExcludeSite);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS_PI.GetPopScoreAvgALLRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Load the population
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="dtFrom"></param>
    /// <param name="dtTo"></param>
    /// <param name="lClinicalSetting"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="lCPATypeID"></param>
    /// <param name="lImpairmentID"></param>
    /// <param name="lInjuryID"></param>
    /// <param name="strGender"></param>
    /// <param name="lMilStatusID"></param>
    /// <param name="strSiteIDs"></param>
    /// <returns></returns>
    public bool LoadPopulation(BaseMaster BaseMstr,
                                  DateTime dtFrom,
                                  DateTime dtTo,
                                  long lClinicalSetting,
                                  long lRegionID,
                                  long lSiteID,
                                  long lCPATypeID,
                                  long lImpairmentID,
                                  long lInjuryID,
                                  string strGender,
                                  long lMilStatusID,
                                  string strSiteIDs)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", BaseMstr.Key);
        
        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        plist.AddInputParameter("pi_nClinicalSetting", lClinicalSetting);
        plist.AddInputParameter("pi_nRegionID", lRegionID);
        plist.AddInputParameter("pi_nSiteID", lSiteID);

        plist.AddInputParameter("pi_nCPATypeID", lCPATypeID);
        plist.AddInputParameter("pi_nImpairmentID", lImpairmentID);
        plist.AddInputParameter("pi_nInjuryID", lInjuryID);
        plist.AddInputParameter("pi_vGender", strGender);
        plist.AddInputParameter("pi_nMilStatusID", lMilStatusID);
        if (strSiteIDs != "-1")
        {
            plist.AddInputParameter("pi_vSiteIDS", "," + strSiteIDs + ",");
        }
        else
        {
            plist.AddInputParameter("pi_vSiteIDS", strSiteIDs);
        }

        //call sp to get ds
        BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_PI.LoadPopulation",
                                         plist,
                                         out lStatusCode,
                                         out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    /// <summary>
    /// load the reports_population_module table
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public bool LoadPopModule(BaseMaster BaseMstr,
                              long lMID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nMID", lMID);
       
        //call sp to get ds
        BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_PI.LoadPopModule",
                                         plist,
                                         out lStatusCode,
                                         out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

}